<?php

namespace Drupal\bootstrap_style_guide\Controller;

use Drupal\Core\Controller\ControllerBase;
use Symfony\Component\HttpFoundation\Response;

/**
 * Defines a controller to render a Bootstrap style guide.
 */
class StyleGuideController extends ControllerBase {

  /**
   * Renders a placeholder image.
   */
  public function placeholderImage($width = 240, $height = 180) {
    $renderer = \Drupal::service('renderer');
    $build = [
      '#theme' => 'bootstrap_placeholder_image',
      '#width' => $width,
      '#height' => $height,
    ];
    $markup = $renderer->render($build);
    return new Response($markup, 200, ['Content-Type' => 'image/svg+xml']);
  }

}
