<?php

declare(strict_types=1);

namespace Drupal\bootstrap_style_guide\Form;

use Drupal\Core\Form\FormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Provides a Bootstrap Style Guide form.
 */
final class StyleGuideForm extends FormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId(): string {
    return 'bootstrap_style_guide_style_guide';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state): array {
    $ret = $form;

    $form = [];

    $form['actions'] = [
      '#type' => 'actions',
    ];

    $form['actions']['submit'] = [
      '#type' => 'submit',
      '#value' => '\'submit\'',
      '#attributes' => [
        ' type' => 'button',
      ],
    ];

    $form['textfield'] = [
      '#type' => 'textfield',
      '#title' => '\'textfield\'',
    ];

    $form['date'] = [
      '#type' => 'date',
      '#title' => '\'date\'',
      '#default_value' => '2020-02-05',
    ];

    $form['email'] = [
      '#type' => 'email',
      '#title' => '\'email\'',
      '#pattern' => '*@example.com',
    ];

    $form['number'] = [
      '#type' => 'number',
      '#title' => '\'number\'',
    ];

    $form['password'] = [
      '#type' => 'password',
      '#title' => '\'password\'',
    ];

    $form['search'] = [
      '#type' => 'search',
      '#title' => '\'search\'',
    ];

    $form['select'] = [
      '#type' => 'select',
      '#title' => '\'select\'',
      '#options' => [
        '1' => '1',
        '2' => [
          '2.1' => '2.1',
          '2.2' => '2.2',
        ],
        '3' => '3',
      ],
    ];

    $form['textarea'] = [
      '#type' => 'textarea',
      '#title' => '\'textarea\'',
    ];

    $form['details'] = [
      '#type' => 'details',
      '#title' => '\'details\'',
      '#open' => TRUE,
      'details_content' => [
        '#markup' => 'This is the details content.',
      ],
    ];

    $form['checkboxes'] = [
      '#type' => 'checkboxes',
      '#title' => '\'checkboxes\'',
      '#default_value' => 0,
      '#options' => [
        0 => $this->t('Option 1'),
        1 => $this->t('Option 2'),
      ],
    ];

    $form['radios'] = [
      '#type' => 'radios',
      '#title' => '\'radios\'',
      '#default_value' => 0,
      '#options' => [
        0 => $this->t('Option 1'),
        1 => $this->t('Option 2'),
      ],
    ];

    $form['range'] = [
      '#type' => 'range',
      '#title' => '\'range\'',
      '#default_value' => 5,
    ];

    $form['table'] = [
      '#prefix' => '<label for="edit-table">\'table\'</label>',
      '#type' => 'table',
      '#header' => ['A', 'B', 'C'],
      '#rows' => [
        ['A1', 'B1', 'C1'],
        ['A2', 'B2', 'C2'],
        ['A3', 'B3', 'C3'],
      ],
      '#empty' => $this->t('No entries available.'),
      '#caption' => 'This is a \'table\' with a caption.',
    ];

    $form['tabs'] = [
      '#type' => 'vertical_tabs',
      '#default_tab' => 'edit-tab-a',
    ];

    $form['tab_a'] = [
      '#type' => 'details',
      '#title' => 'Vertical Tab A',
      '#group' => 'tabs',
      'text' => [
        '#markup' => 'Vertical Tab A Content',
      ],
    ];

    $form['tab_b'] = [
      '#type' => 'details',
      '#title' => 'Vertical Tab B',
      '#group' => 'tabs',
      'text' => [
        '#markup' => 'Vertical Tab B Content',
      ],
    ];

    $ret['wrapper'] = [
      '#theme' => 'bootstrap_style_guide',
      ...$form,
    ];

    return $ret;
  }

  /**
   * {@inheritdoc}
   */
  public function validateForm(array &$form, FormStateInterface $form_state): void {
    // @todo Validate the form here.
    // Example:
    // @code
    //   if (mb_strlen($form_state->getValue('message')) < 10) {
    //     $form_state->setErrorByName(
    //       'message',
    //       $this->t('Message should be at least 10 characters.'),
    //     );
    //   }
    // @endcode
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state): void {
    $this->messenger()->addStatus($this->t('The message has been sent.'));
    $form_state->setRedirect('<front>');
  }

}
