<?php

namespace Monarch\ComposerInformation;

use Composer\Autoload\ClassLoader;

/**
 * Allows this class to use caching for the current live of the class.
 */
trait ComposerInformationTrait {

  /**
   * Gets the vendor directory.
   */
  protected function getVendorDir() {
    $loaders = ClassLoader::getRegisteredLoaders();

    if (count($loaders) === 1) {
      return key($loaders);
    }

    $reflector = new \ReflectionClass(self::class);
    $kernelFilePath = $reflector->getFileName();

    foreach (array_keys($loaders) as $path) {
      if (str_starts_with($kernelFilePath, dirname($path))) {
        return $path;
      }
    }

    return key($loaders);
  }

  /**
   * Gets and decodes the installed.json file.
   */
  protected function getComposerInstalledJson() {
    $path = realpath(implode(DIRECTORY_SEPARATOR, [
      $this->getVendorDir(),
      'composer',
      'installed.json',
    ]));

    if ($path) {
      return file_get_contents($path);
    }
  }

  /**
   * Gets and decodes the composer.json file.
   */
  protected function getComposerJson() {
    $path = realpath(implode(DIRECTORY_SEPARATOR, [
      $this->getVendorDir(),
      '..',
      'composer.json',
    ]));

    if ($path) {
      return file_get_contents($path);
    }
  }

}
