(function (Drupal, $) {
  function getParent (element) {
    return element.closest('[data-ajax-content-target]');
  }

  function elementClick (e) {
    if (e.target !== e.currentTarget && e.target.tagName === 'A') {
      return;
    }

    let parent = getParent(e.currentTarget);

    if (parent) {
      let actionName = e.currentTarget.dataset.ajaxContentClick || e.currentTarget.getAttribute('name') || '',
        query = actionName.length ? '?_ajax_content_event=' + encodeURIComponent(actionName) : null,
        ajax = {
          url: parent.dataset.ajaxContentTarget + query,
          submit: $(parent).serialize() || '',
        };

      Drupal.ajax(ajax).execute();

      e.preventDefault();
      e.stopPropagation();
    }
  }

  function elementChange (e) {
    e.preventDefault();
    e.stopPropagation();

    let parent = getParent(e.currentTarget);

    if (parent) {
      let actionName = e.currentTarget.dataset.ajaxContentChanged || e.currentTarget.getAttribute('name') || '',
        query = actionName.length ? '?_ajax_content_event=' + encodeURIComponent(actionName) : null,
        ajax = {
          url: parent.dataset.ajaxContentTarget + query,
          submit: $(parent).serialize() || '',
        };

      Drupal.ajax(ajax).execute();
    }
  }

  function elementSubmit (e) {
    let actionName = e.currentTarget.dataset.ajaxContentSubmit || 'submit',
    query = actionName.length ? '?_ajax_content_event=' + encodeURIComponent(actionName) : '',
    ajax = {
      url: e.currentTarget.dataset.ajaxContentTarget + query,
      submit: $(e.currentTarget).serialize() || '',
    };

    console.log('ajax execute', ajax);
    Drupal.ajax(ajax).execute();

    e.preventDefault();
    e.stopPropagation();
    return false;
  }

  Drupal.behaviors.monarchAjaxContentLoader = {
    attach() {
      $('[data-ajax-content-element]').each(function () {
        if (!this.dataset.ajaxContentElementInit && this.dataset.ajaxContentTarget) {
          this.dataset.ajaxContentElementInit = 'true';
          let observer = new IntersectionObserver(entries => {
            let isVisible = entries[0].intersectionRatio > 0;

            if (isVisible) {
              observer.disconnect();
              Drupal.ajax({ url: this.dataset.ajaxContentTarget }).execute();
            }
          });

          observer.observe(this);
        }
      });

      $('[data-ajax-content-element]').each(function () {
        this.removeEventListener('submit', elementSubmit);
        this.addEventListener('submit', elementSubmit);
      });

      $('[data-ajax-content-click]').each(function () {
        this.removeEventListener('click', elementClick);
        this.addEventListener('click', elementClick);
      });

      $('[data-ajax-content-changed]').each(function () {
        this.removeEventListener('change', elementChange);
        this.addEventListener('change', elementChange);
      });
    },
  };
})(Drupal, jQuery);
