<?php

namespace Drupal\monarch_ajax_content;

use Drupal\Component\Plugin\PluginBase;
use Drupal\Core\StringTranslation\StringTranslationTrait;
use Drupal\Core\Url;

/**
 * Base class for ajax_content plugins.
 */
abstract class AjaxContentPluginBase extends PluginBase implements AjaxContentInterface {

  use StringTranslationTrait;

  /**
   * {@inheritdoc}
   */
  public function buildWrapper(array &$element) {
    $id = $this->pluginDefinition['id'];

    $element['wrapper'] = [
      '#type' => 'html_tag',
      '#tag' => $this->pluginDefinition['tag'] ?? 'div',
      '#attached' => [
        'library' => [
          'monarch_ajax_content/default',
        ],
      ],
    ];

    $element['wrapper']['#attributes']['data-ajax-content-element'] = $id;
    $element['wrapper']['#attributes']['data-ajax-content-target'] = Url::fromRoute('monarch_ajax_content.monarch_ajax_content_loader', ['id' => $id])->toString();
  }

  /**
   * {@inheritdoc}
   */
  public function preRender(array &$build, bool $is_root) {
    if ($build['#click'] ?? NULL) {
      $build['#attributes']['data-ajax-content-click'] = $build['#attributes']['data-ajax-content-click'] ?? $build['#click'] ?? NULL;
    }

    if ($build['#changed'] ?? NULL) {
      $build['#attributes']['data-ajax-content-changed'] = $build['#attributes']['data-ajax-content-changed'] ?? $build['#changed'] ?? NULL;
    }

    foreach ($build as $key => &$value) {
      if (is_string($key) && $key[0] === '#' || !is_array($value)) {
        continue;
      }

      $this->preRender($value, FALSE);
    }
  }

}
