<?php

namespace Drupal\monarch_ajax_content;

use Drupal\Core\Cache\CacheBackendInterface;
use Drupal\Core\Extension\ModuleHandlerInterface;
use Drupal\Core\Plugin\DefaultPluginManager;
use Drupal\monarch_ajax_content\Annotation\AjaxContent;

/**
 * AjaxContent plugin manager.
 */
final class AjaxContentPluginManager extends DefaultPluginManager {

  /**
   * Constructs the object.
   */
  public function __construct(\Traversable $namespaces, CacheBackendInterface $cache_backend, ModuleHandlerInterface $module_handler) {
    parent::__construct('Plugin/AjaxContent', $namespaces, $module_handler, AjaxContentInterface::class, AjaxContent::class);
    $this->alterInfo('ajax_content_info');
    $this->setCacheBackend($cache_backend, 'ajax_content_plugins');
  }

}
