<?php

namespace Drupal\monarch_ajax_content\Controller;

use Drupal\Core\Ajax\AjaxResponse;
use Drupal\Core\Ajax\HtmlCommand;
use Drupal\Core\Controller\ControllerBase;
use Drupal\Core\Render\RendererInterface;
use Drupal\monarch_ajax_content\AjaxContentPluginManager;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\HttpFoundation\Request;

/**
 * Returns responses for monarch_ajax_content routes.
 */
class MonarchAjaxContentLoader extends ControllerBase {

  /**
   * The ajax content plugin manager.
   */
  protected AjaxContentPluginManager $ajaxContentPluginManager;

  /**
   * The renderer service.
   */
  protected RendererInterface $renderer;

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container): static {
    $instance = new static();

    $instance->entityTypeManager = $container->get('entity_type.manager');
    $instance->ajaxContentPluginManager = $container->get('plugin.manager.ajax_content');
    $instance->renderer = $container->get('renderer');

    return $instance;
  }

  /**
   * Builds the response.
   */
  public function __invoke(string $id, Request $request): AjaxResponse {
    $response = new AjaxResponse();

    /** @var \Drupal\monarch_ajax_content\Element\AjaxContentInterface $plugin */
    if ($plugin = $this->ajaxContentPluginManager->createInstance($id)) {
      $ajax_content_click = $request->query->get('_ajax_content_event');
      $build = $plugin->build($ajax_content_click, $request);
      if (method_exists($plugin, 'preRender')) {
        $plugin->preRender($build, TRUE);
      }
      $markup = $this->renderer->renderRoot($build);
      $response->setAttachments($build['#attached'] ?? []);
      $selector = '[data-ajax-content-element="' . $id . '"]';
      $response->addCommand(new HtmlCommand($selector, $markup));
    }

    return $response;
  }

}
