<?php

namespace Drupal\monarch_ajax_content\Plugin\AjaxContent;

use Drupal\monarch_ajax_content\AjaxContentPluginBase;
use Symfony\Component\HttpFoundation\Request;

/**
 * Plugin implementation of the ajax_content.
 *
 * @AjaxContent(
 *   id = "example",
 *   tag = "form",
 *   lazy = true,
 * )
 */
final class Example extends AjaxContentPluginBase {

  /**
   * {@inheritdoc}
   */
  public function build(?string $event, ?Request $request) : array {
    $post = $request ? $request->request->all() : [];

    $build = [
      '#prefix' => '<div class="row mt-5 justify-content-center">',
      '#suffix' => '</div>',
      'formula' => [
        '#prefix' => '<div class="col-auto">',
        '#suffix' => '</div>',
        '#type' => 'html_tag',
        '#tag' => 'input',
        '#attributes' => [
          'name' => 'formula',
          'size' => '60',
          'placeholder' => 'Enter a math expression here...',
          'value' => $post['formula'] ?? NULL,
        ],
      ],
      'calc' => [
        '#prefix' => '<div class="col-auto">',
        '#suffix' => '</div>',
        '#type' => 'html_tag',
        '#tag' => 'button',
        // This '#click' is a special render array attribute to simplify adding
        // click events to almost any element. When this element is rendered in
        // response to an event, it is passed in $event to the build function.
        '#click' => 'calc',
        '#attributes' => [
          'type' => 'button',
          'class' => ['btn', 'btn-primary', 'btn-sm', 'text-white'],
        ],
        'title' => ['#plain_text' => $this->t('Calculate')],
      ],
      'div' => ['#markup' => '<div class="col-12"></div>'],
      'result' => [
        '#prefix' => '<div class="col-auto mt-3">',
        '#suffix' => '</div>',
      ],
    ];

    if ($event === 'calc') {
      if ($formula = $post['formula'] ?? NULL) {
        $formula = escapeshellarg($formula);
        // This must be running in linux with the bc package installed.
        $build['result']['#plain_text'] = 'Result: ' . `echo $formula | bc`;
      }
    }

    return $build;
  }

}
