<?php

namespace Drupal\monarch_algolia_index\EventSubscriber;

use Drupal\monarch_algolia_index\Indexer;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Symfony\Component\HttpKernel\Event\TerminateEvent;
use Symfony\Component\HttpKernel\KernelEvents;

/**
 * Event subscriber for indexing.
 */
final class EventSubscriber implements EventSubscriberInterface {

  /**
   * Constructs an Indexer object.
   */
  public function __construct(
    private readonly Indexer $indexer,
  ) {}

  /**
   * Kernel request event handler.
   */
  public function onTerminate(TerminateEvent $event): void {
    $path = $event->getRequest()->getPathInfo();

    if ($path !== '/batch') {
      $this->indexer->processQueue();
    }
  }

  /**
   * {@inheritdoc}
   */
  public static function getSubscribedEvents(): array {
    return [
      KernelEvents::TERMINATE => ['onTerminate'],
    ];
  }

}
