<?php

namespace Drupal\monarch_algolia_index\Form;

use Drupal\Core\Entity\EntityTypeBundleInfoInterface;
use Drupal\Core\Entity\EntityTypeManagerInterface;
use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\monarch_algolia_index\Indexer;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Configure Algolia Index settings for this site.
 */
final class SettingsForm extends ConfigFormBase {

  /**
   * The entity_type.manager service.
   */
  protected EntityTypeManagerInterface $entityTypeManager;

  /**
   * The entity_type.bundle.info service.
   */
  protected EntityTypeBundleInfoInterface $entityTypeBundleInfo;

  /**
   * The algolia_index.indexer service.
   */
  protected Indexer $indexer;

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container) {
    $instance = parent::create($container);

    $instance->entityTypeManager = $container->get('entity_type.manager');
    $instance->entityTypeBundleInfo = $container->get('entity_type.bundle.info');
    $instance->indexer = $container->get('algolia_index.indexer');

    return $instance;
  }

  /**
   * {@inheritdoc}
   */
  public function getFormId(): string {
    return 'monarch_algolia_index_settings';
  }

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames(): array {
    return ['monarch_algolia_index.settings'];
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state): array {
    $config = $this->config(current($this->getEditableConfigNames()));

    $form['appid'] = [
      '#type' => 'textfield',
      '#title' => $this->t('App ID'),
      '#description' => $this->t('May also be known as public key.'),
      '#default_value' => $config->get('appid'),
    ];

    $form['apikey'] = [
      '#type' => 'textfield',
      '#title' => $this->t('API Key'),
      '#description' => $this->t('May also be known as private key.'),
      '#default_value' => $config->get('apikey'),
    ];

    $form['index'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Index Name'),
      '#description' => $this->t('Can be any index name. It will be created if needed.'),
      '#default_value' => $config->get('index'),
    ];

    $form['site'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Site Code'),
      '#description' => $this->t('This is used to differentiate content from other sites.'),
      '#placeholder' => 'default',
      '#default_value' => $config->get('site'),
    ];

    $form['environment'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Environment Code'),
      '#description' => $this->t('This is used to differentiate between environments for a site.'),
      '#placeholder' => 'dev',
      '#default_value' => $config->get('environment'),
    ];

    $form['allow'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Allow Indexing'),
      '#default_value' => $config->get('allow'),
    ];

    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state): void {
    $config = $this->config(current($this->getEditableConfigNames()));

    $config
      ->set('appid', $form_state->getValue('appid'))
      ->set('apikey', $form_state->getValue('apikey'))
      ->set('index', $form_state->getValue('index'))
      ->set('site', $form_state->getValue('site'))
      ->set('environment', $form_state->getValue('environment'))
      ->set('allow', $form_state->getValue('allow'))
      ->save();

    parent::submitForm($form, $form_state);
  }

}
