<?php

namespace Drupal\monarch_analytics;

use Drupal\Component\EventDispatcher\Event;
use Drupal\Core\Session\AccountInterface;
use Drupal\Core\Url;
use Symfony\Component\HttpFoundation\Request;

/**
 * Metrics event data.
 */
class MetricsEvent extends Event {

  const CLICK = 'monarch_metrics_click';
  const VIEW = 'monarch_metrics_view';
  const LANDING = 'monarch_metrics_landing';
  const HIDE = 'monarch_metrics_hide';
  const SHOW = 'monarch_metrics_show';

  /**
   * Construct the object.
   */
  public function __construct(
    public readonly string $event,
    public readonly string $href,
    public readonly Url $url,
    public readonly bool $isAdminRoute,
    public readonly ?array $metadata,
    public readonly ?AccountInterface $account,
    public readonly Request $request,
    public readonly ?array $originalHeaders,
  ) {}

}
