(function () {
  function buildQuery(params) {
    let query = [];

    for (let key in params) {
      query.push(encodeURIComponent(key) + '=' + encodeURIComponent(params[key]));
    }

    return query.join('&');
  }

  function onAnchorClick (e) {
    let elem = e.currentTarget || e.target;
  
    if (elem instanceof HTMLAnchorElement) {
      // Defer so that other handlers may prevent default, and we can react to that.
      setTimeout(() => {
        if (e.defaultPrevented) {
          return;
        }

        let query = {
          href: elem.href,
          code: drupalSettings.monarch_analytics.code,
          t: (performance.timeOrigin + performance.now()).toFixed(3).replace('.', ''),
          'metadata[parent][href]': window.location.href,
          'metadata[parent][query]': document.location.search.slice(1),
        };
  
        for (let key in elem.dataset) {
          query[`metadata[${key}]`] = elem.dataset[key];
        }
  
        fetch('/UrlMetrics/Click?' + buildQuery(query));
      }, 0);
    }
  }

  function registerInsightClicks () {
    document.querySelectorAll('a').forEach(elem => {
      elem.removeEventListener('click', onAnchorClick);
      elem.addEventListener('click', onAnchorClick);
    });
  }

  if (!drupalSettings.dxp_algolia_api?.isAdminRoute) {
    let mutationObserver = new MutationObserver(registerInsightClicks);

    mutationObserver.observe(document.body, {
      subtree: true,
      childList: true,
      attributes: true,
    });

    registerInsightClicks();
  }

  window.addEventListener('load', () => {
    fetch('/UrlMetrics/View?' + buildQuery({
      href: window.location.href,
      code: drupalSettings.monarch_analytics.code,
      t: (performance.timeOrigin + performance.now()).toFixed(3).replace('.', ''),
      'metadata[query]': document.location.search.slice(1),
    }));
  });

  document.addEventListener('visibilitychange', () => {
    let isHidden = document.visibilityState === 'hidden';

    fetch('/UrlMetrics/' + (isHidden ? 'Hide' : 'Show') + '?' + buildQuery({
      href: window.location.href,
      code: drupalSettings.monarch_analytics.code,
      t: (performance.timeOrigin + performance.now()).toFixed(3).replace('.', ''),
      'metadata[query]': document.location.search.slice(1),
    }));
  });  
})();
