<?php

namespace Drupal\monarch_statistics\EventSubscriber;

use Drupal\Component\Datetime\DateTimePlus;
use Drupal\Core\Database\Connection;
use Drupal\monarch_analytics\MetricsEvent;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

/**
 * Metrics event subscriber.
 */
final class MetricsEventSubscriber implements EventSubscriberInterface {

  /**
   * Constructs a MetricsEventSubscriber object.
   */
  public function __construct(
    private readonly Connection $database,
  ) {}

  /**
   * Respond to view event.
   */
  public function view(MetricsEvent $event): void {
    $timezone = \Drupal::config('system.date')->get('timezone')['default'] ?? 'UTC';
    $date = new DateTimePlus('now', $timezone);
    $date->setTime(0, 0, 0, 0);
    $timestamp = $date->getTimestamp();

    $this->database->merge('monarch_statistics')
      ->keys(['path', 'timestamp'], [$event->href, $timestamp])
      ->insertFields(['path', 'timestamp', 'count'], [$event->href, $timestamp, 0])
      ->execute();

    $this->database->update('monarch_statistics')
      ->expression('count', 'count + 1')
      ->condition('path', $event->href)
      ->condition('timestamp', $timestamp)
      ->execute();
  }

  /**
   * {@inheritdoc}
   */
  public static function getSubscribedEvents(): array {
    return [
      MetricsEvent::VIEW => ['view'],
    ];
  }

}
