<?php

if (!function_exists('node_get_recent')) {
  function node_get_recent($number = 10) {
    monarch_bc_log(__FUNCTION__, 'Drupal 10', '@see https://www.drupal.org/node/3356654');

    $account = \Drupal::currentUser();
    $query = \Drupal::entityQuery('node');
    if (!$account
      ->hasPermission('bypass node access')) {
  
      // If the user is able to view their own unpublished nodes, allow them
      // to see these in addition to published nodes. Check that they actually
      // have some unpublished nodes to view before adding the condition.
      $access_query = \Drupal::entityQuery('node')
        ->accessCheck(TRUE)
        ->condition('uid', $account
        ->id())
        ->condition('status', NodeInterface::NOT_PUBLISHED);
      if ($account
        ->hasPermission('view own unpublished content') && ($own_unpublished = $access_query
        ->execute())) {
        $query
          ->orConditionGroup()
          ->condition('status', NodeInterface::PUBLISHED)
          ->condition('nid', $own_unpublished, 'IN');
      }
      else {
  
        // If not, restrict the query to published nodes.
        $query
          ->condition('status', NodeInterface::PUBLISHED);
      }
    }
    $nids = $query
      ->accessCheck(TRUE)
      ->sort('changed', 'DESC')
      ->range(0, $number)
      ->addTag('node_access')
      ->execute();
    $nodes = Node::loadMultiple($nids);
    return $nodes ? $nodes : [];
  }
}
