<?php


if (!function_exists('user_roles')) {
  /**
   * @see https://www.drupal.org/node/3349759
   * @see https://api.drupal.org/api/drupal/core%21modules%21user%21user.module/function/user_roles/8.9.x
   */
  function user_roles($membersonly = FALSE, $permission = NULL) {
    monarch_bc_log(__FUNCTION__, 'Drupal 10', '@see https://www.drupal.org/node/3349759');

    $roles = Role::loadMultiple();
    if ($membersonly) {
      unset($roles[RoleInterface::ANONYMOUS_ID]);
    }
    if (!empty($permission)) {
      $roles = array_filter($roles, function ($role) use ($permission) {
        return $role
          ->hasPermission($permission);
      });
    }
    return $roles;
  }
}

if (!function_exists('user_role_names')) {
  /**
   * @see https://www.drupal.org/node/3349759
   * @see https://api.drupal.org/api/drupal/core%21modules%21user%21user.module/function/user_role_names/8.9.x
   */
  function user_role_names($membersonly = FALSE, $permission = NULL) {
    monarch_bc_log(__FUNCTION__, 'Drupal 9', '@see https://www.drupal.org/node/3349759');

    return array_map(function ($item) {
      return $item
        ->label();
    }, user_roles($membersonly, $permission));
  }
}


