<?php

if (!function_exists('watchdog_exception')) {

  function watchdog_exception($type, Exception $exception, $message = NULL, $variables = [], $severity = RfcLogLevel::ERROR, $link = NULL) {
    monarch_bc_log(__FUNCTION__, 'Drupal 10', '@see https://www.drupal.org/node/2932520');

    // Use a default value if $message is not set.
    if (empty($message)) {
      $message = Error::DEFAULT_ERROR_MESSAGE;
    }
    if ($link) {
      $variables['link'] = $link;
    }
    $variables += Error::decodeException($exception);
    \Drupal::logger($type)
      ->log($severity, $message, $variables);
  }
}