<?php

if (!function_exists('file_create_url')) {
  /**
   * @see https://www.drupal.org/node/2940031
   * @see https://api.drupal.org/api/drupal/core%21includes%21file.inc/function/file_create_url/9
   */
  function file_create_url($uri){
    monarch_bc_log(__FUNCTION__, 'Drupal 9', '@see https://www.drupal.org/node/2940031');

    return(\Drupal::service('file_url_generator')->generateAbsoluteString($uri));
  }
}

if (!function_exists('file_url_transform_relative')) {
  /**
   * @see https://www.drupal.org/node/2940031
   * @see https://api.drupal.org/api/drupal/core%21includes%21file.inc/function/file_url_transform_relative/8.9.x
   */
  function file_url_transform_relative($file_url) {
    monarch_bc_log(__FUNCTION__, 'Drupal 9', '@see https://www.drupal.org/node/2940031');

    return(\Drupal::service('file_url_generator')->transformRelative($file_url));
  }
}

if (!function_exists('drupal_get_path')) {
  /**
   * Function drupal_get_path().
   */
  function drupal_get_path($extension, $resolver = 'standard') {
    monarch_bc_log(__FUNCTION__, 'Drupal 9', '@see https://www.drupal.org/node/2940438');
    return(\Drupal::service('extension.list.' . $extension)->getPath($resolver));
  }

}

if (!function_exists('drupal_get_filename')) {
  /**
   * Function drupal_get_filename().
   */
  function drupal_get_filename($extension, $resolver) {
    monarch_bc_log(__FUNCTION__, 'Drupal 9', '@see https://www.drupal.org/node/2940438');
    return(\Drupal::service('extension.list.' . $extension)->getPathname($resolver));
  }

}
