/**
 * @file
 * Javascript Behaviors to initialize blueimp galleries.
 */

(function ($, Drupal) {

  /**
   * Initialize blueimp galleries on the page.
   */
  Drupal.behaviors.monarchBlueImp = {
    attach: function (context, settings) {
      $.each(settings.monarch_blueimp.galleries, function(id, gallery) {
        if (gallery.settings.carousel) {
          gallery.settings.onslide = function (index, slide) {
            Array.from(this.container.find('.description')).forEach(elem => {
              elem.innerHTML = gallery.media[index].description || '';
            });
          };

          blueimp.Gallery(gallery.media, gallery.settings);
        }
        else {
          $('#' + id + '-links').on('click', function(e) {
            var target = e.target || e.srcElement;
            var link = target.src ? target.parentNode : target;
            var links = gallery.media || $(this).find('a').toArray();

            // Scroll bars do not return when modal is closed. This is a fix.
            gallery.settings.hidePageScrollbars = false;
            
            gallery.settings.index = link;
            gallery.settings.event = e;
            
            // Scroll bars do not return when modal is closed. This is a fix.
            gallery.settings.hidePageScrollbars = false;

            blueimp.Gallery(links, gallery.settings);
          });
        }
      });
    }
  };

})(jQuery, Drupal);