<?php

namespace Drupal\monarch_bootstrap\Plugin\Alter;

use Drupal\Core\Plugin\PluginBase;
use Drupal\Core\Plugin\ContainerFactoryPluginInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Drupal\Core\StringTranslation\StringTranslationTrait;

/**
 * Base class for alter plugins.
 */
abstract class AlterBase extends PluginBase implements AlterInterface, ContainerFactoryPluginInterface {

  use StringTranslationTrait;

  /**
   * The alter hook invoked.
   *
   * @var string
   */
  protected $hook;

  /**
   * The theme manager service.
   *
   * @var \Drupal\Core\Theme\ThemeManagerInterface
   */
  protected $themeManager;

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, array $configuration, $plugin_id, $plugin_definition) {
    $instance = new static($configuration, $plugin_id, $plugin_definition);
    $instance->themeManager = $container->get('theme.manager');
    return $instance;
  }

  /**
   * {@inheritdoc}
   */
  public function __construct(array $configuration, $plugin_id, $plugin_definition) {
    parent::__construct($configuration, $plugin_id, $plugin_definition);
    $this->hook = $configuration['hook'] ?? NULL;
  }

  /**
   * Get the active theme object.
   *
   * @return \Drupal\Core\Theme\ActiveTheme
   *   The active theme object.
   */
  public function getActiveTheme() {
    return $this->themeManager->getActiveTheme();
  }

}
