<?php

namespace Drupal\monarch_bootstrap\Plugin\Preprocess;

use Drupal\Component\Utility\Html;

/**
 * Pre-processes variables for the menu template.
 *
 * @MonarchPreprocess("menu")
 */
class Menu extends PreprocessBase {

  /**
   * {@inheritdoc}
   */
  public function preprocess(array &$variables, $hook, array $info) {
    parent::preprocess($variables, $hook, $info);

    $menu = $variables['menu_name'];
    $settings = $this->getThemeSetting('menus.' . $menu);

    $variables['id'] = Html::getUniqueId('menu-' . $menu);
    $variables['title_id'] = Html::getUniqueId('menu-' . $menu . '-title');

    // Add standard attributes.
    $variables['attributes']['role'] = 'navigation';
    $variables['attributes']['aria-labelledby'] = $variables['title_id'];
    $variables['attributes']['class'][] = 'menu';
    $variables['attributes']['class'][] = 'menu--' . Html::getClass($menu);
    $variables['attributes']['class'][] = 'navbar';

    // Title is not displayed but still provided for screen readers.
    $variables['title_attributes']['id'] = $variables['title_id'];
    $variables['title_attributes']['class'][] = 'visually-hidden';

    // Attributes applied to the menu <ul> tag.
    $variables['content_attributes']['class'][] = 'navbar-nav';
    $variables['content_attributes']['class'][] = 'mr-auto';

    $variables['collapse'] = FALSE;
    if (!empty($settings['expand']) && $settings['expand'] != 'none') {
      if ($settings['expand'] != 'navbar-expand') {
        $variables['collapse'] = TRUE;
      }
      $variables['attributes']['class'][] = $settings['expand'];
    }

    if (!empty($settings['position']) && $settings['position'] != 'none') {
      $variables['attributes']['class'][] = $settings['position'];
    }

    // Custom classes
    if (!empty($settings['classes'])) {
      $classes = explode(' ', $settings['classes']);
      foreach ($classes as $class) {
        $variables['attributes']['class'][] = trim($class);
      }
    }

  }
}
