<?php

namespace Drupal\monarch_bootstrap\Plugin\Preprocess;

/**
 * Pre-processes variables for buttons.
 *
 * @MonarchPreprocess("pager")
 */
class Pager extends PreprocessBase {

  /**
   * {@inheritdoc}
   */
  public function preprocess(array &$variables, $hook, array $info) {
    parent::preprocess($variables, $hook, $info);
    $settings = $this->getThemeSetting('components.pager');

    if (!empty($settings['pager_size']) && $settings['pager_size'] != 'default') {
      $variables['attributes']['class'][] = $settings['pager_size'];
    }

    if (!empty($settings['pager_align']) && $settings['pager_align'] != 'default') {
      $variables['attributes']['class'][] = $settings['pager_align'];
    }
  }

}
