<?php

namespace Drupal\monarch_bootstrap\Plugin\Alter;

/**
 * Defines the interface for an alter plugin.
 */
interface AlterInterface {

  /**
   * Alter the data.
   *
   * @param mixed $data
   *   The data to be altered. Passed by reference.
   * @param mixed $context1
   *   (optional) Additional contextual information for the alter hook. Passed
   *   by reference.
   * @param mixed $context2
   *   (optional) Additional contextual information for the alter hook. Passed
   *   by reference.
   */
  public function alter(&$data, &$context1 = NULL, &$context2 = NULL);

}
