<?php

namespace Drupal\monarch_bootstrap\Plugin\Alter\Form;

use Drupal\monarch_bootstrap\Plugin\Alter\AlterBase;

/**
 * Form alter base for login forms.
 *
 * Replaces the betterlogin module.
 */
abstract class LoginFormAlterBase extends AlterBase {

  /**
   * {@inheritdoc}
   */
  public function alter(&$data, &$context1 = NULL, &$context2 = NULL) {
    $form = &$data;

    // Autofocus the name field.
    $form['name']['#attributes']['autofocus'] = 'autofocus';

    // We don't really need descriptions to tell us what we already know...
    unset($form['name']['#description']);
    unset($form['pass']['#description']);
  }

}
