<?php

namespace Drupal\monarch_bootstrap\Plugin\Alter\Form;

use Drupal\monarch_bootstrap\Plugin\Alter\AlterBase;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Form alter plugin.
 *
 * @MonarchAlter("node_form")
 */
class NodeFormAlter extends AlterBase {

  /**
   * The URL Generator service.
   *
   * @var \Drupal\Core\Routing\UrlGeneratorInterface
   */
  protected $urlGenerator;

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, array $configuration, $plugin_id, $plugin_definition) {
    $instance = new static($configuration, $plugin_id, $plugin_definition);
    $instance->urlGenerator = $container->get('url_generator');
    return $instance;
  }

  /**
   * {@inheritdoc}
   */
  public function alter(&$data, &$context1 = NULL, &$context2 = NULL) {
    $form = &$data;
    $form_state = $context1;
    $form_id = $context2;

    $form['#theme'] = ['node_edit_form'];

    // Get the base url withouth the trailing slash.
    $base_url = $this->urlGenerator->generateFromRoute('<front>', [], ['absolute' => TRUE]);
    $base_url = substr($base_url, 0, -1);

    $form['revision_information']['#type'] = 'details';
    unset($form['revision_information']['#group']);

    // Improve the path field.
    if (isset($form['path']['widget'][0])) {
      unset($form['path']['widget'][0]['#group']);
      unset($form['path']['widget'][0]['alias']['#description']);
      $form['path']['widget'][0]['#type'] = 'container';
      $form['path']['widget'][0]['alias']['#title'] = $this->t('Page URL:');
      $form['path']['widget'][0]['alias']['#field_prefix'] = $base_url;
      $form['path']['widget'][0]['alias']['#weight'] = 1;

      // Pathauto checkbox.
      if (isset($form['path']['widget'][0]['pathauto'])) {
        $form['path']['widget'][0]['pathauto']['#title'] = $this->t('Automatic URL');
        $form['path']['widget'][0]['pathauto']['#description'] = $this->t('Uncheck this to create a custom URL above.');
        $form['path']['widget'][0]['pathauto']['#weight'] = 2;
      }
    }
  }

}
