<?php

namespace Drupal\monarch_bootstrap\Plugin\Preprocess;

use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Pre-processes variables for the page template.
 *
 * @MonarchPreprocess("block")
 */
class Block extends PreprocessBase {

  /**
   * The entity_type.manager service.
   *
   * @var \Drupal\Core\Entity\EntityTypeManagerInterface
   */
  protected $entityTypeManager = NULL;

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, array $configuration, $plugin_id, $plugin_definition) {
    $instance = parent::create($container, $configuration, $plugin_id, $plugin_definition);
    $instance->entityTypeManager = $container->get('entity_type.manager');
    return $instance;
  }

  /**
   * {@inheritdoc}
   */
  public function preprocess(array &$variables, $hook, array $info) {
    parent::preprocess($variables, $hook, $info);

    $block_id = $variables['elements']['#id'] ?? NULL;

    if (!empty($block_id)) {
      /** @var \Drupal\block\BlockInterface $block */
      $block = $this->entityTypeManager->getStorage('block')->load($block_id);

      if (!empty($block)) {
        $variables['region'] = $block->getRegion();
      }
    }
  }

}
