<?php

namespace Drupal\monarch_bootstrap\Plugin\Preprocess;

use Drupal\Component\Utility\Html;

/**
 * Pre-processes variables for the region template.
 *
 * @MonarchPreprocess("region")
 */
class Region extends PreprocessBase {

  /**
   * {@inheritdoc}
   */
  public function preprocess(array &$variables, $hook, array $info) {
    parent::preprocess($variables, $hook, $info);

    $region = $variables['region'];
    $settings = $this->getThemeSetting('regions.' . $region);

    // Add standard classes.
    $variables['attributes']['class'][] = 'region';
    $variables['attributes']['class'][] = 'region--' . Html::getClass($region);

    // Add bootstrap classes from settings.
    if (!empty($settings['container']) && $settings['container'] != 'none') {
      $variables['container_class'] = $settings['container'];
    }

    if (!empty($settings['bg_color']) && $settings['bg_color'] != 'none') {
      $variables['attributes']['class'][] = $settings['bg_color'];
    }

    // Other classes
    if (!empty($settings['classes'])) {
      $classes = explode(' ', $settings['classes']);
      foreach ($classes as $class) {
        $variables['attributes']['class'][] = trim($class);
      }
    }
  }
}
