/**
 * @file
 * Gulp configurations and tasks for compiling scss.
 */
'use strict';

const gulp = require('gulp');
const sass = require('gulp-sass')(require('sass'));
const sassGlob = require('gulp-sass-glob');
const autoprefixer = require('gulp-autoprefixer');
const sourcemaps = require('gulp-sourcemaps');

let tasks = [
  { type: 'sass', watch: ['scss/*.scss', 'scss/**/*.scss'], source: 'scss/*.scss', target: 'css/' }
];

let taskTypes = {
  sass: task => () => gulp.src(task.source, { allowEmpty: true })
    .pipe(sassGlob())
    .pipe(sourcemaps.init())
    .pipe(sass({ outputStyle: 'compressed' }).on('error', sass.logError))
    .pipe(autoprefixer())
    .pipe(sourcemaps.write(''))
    .pipe(gulp.dest(task.target)),
};

tasks.forEach(task => {
  if (taskTypes[task.type]) {
    task.exec = taskTypes[task.type](task);
  } else {
    throw new Error(`No task type for ${task.type} defined!`);
  }
  return gulp.task(task.source, task.exec);
});

gulp.task('make', gulp.parallel(...tasks.map(task => task.source)));
gulp.task('watch-for-changes', () => {
  tasks.map(task => {
    gulp.watch(task.watch, gulp.series(task.source));
  });
});
gulp.task('watch', gulp.series('make', 'watch-for-changes'));