# Base theme SCSS Source Files

The base theme does not contain any compiled CSS code but provides some generic styles in the form of SCSS that can be imported in your subtheme. Add the following to your subtheme's primary SCSS collector file after importing bootstrap components:

  ```@import [path_to_base_theme]/scss/components/**/*.scss```

> Note: The base theme does not include bootstrap source styles. These must be imported in the subtheme prior to importing the base theme SCSS in order to facilitate variable/mixin overrides and optimization. See the 'subtheme' directory for a starter template incorporating the bootstrap dependency and import structure.

## SCSS File Naming and Structure

SCSS files that are meant to be imported by another file should begin with an underscore to indicate that they are not compiled directly. For example /scss/global_styling/components/node/_node.scss

SCSS files should be organized according to the theme library they belong to. For example, node styles are part of the global styling library and belong in /scss/global_styling/components/node/_node.scss.

When styles applie to more specific versions of a compnent, for example a specific content type, the styles may be placed in a separate source file. eg /sass/global_styling/components/node/_node-article.scss.

  Note: SCSS files should use dashes instead of underscores (similar to template naming).

Styles for modules that exist on most sites such as node, views, betterlogin etc belong in the global_styling library. Styles for less common modules such as paragraphs or commerce should be placed in a separate library that can be included on an as-needed basis.
