<?php

namespace Drupal\monarch_bootstrap\Plugin\Preprocess;

/**
 * Pre-processes variables for buttons.
 *
 * @MonarchPreprocess("input")
 */
class Input extends PreprocessBase {

  /**
   * {@inheritdoc}
   */
  public function preprocess(array &$variables, $hook, array $info) {
    parent::preprocess($variables, $hook, $info);
    $settings = $this->getThemeSetting('components.input');
    $element = $variables['element'];

    if (isset($element['#button_type']) && $element['#button_type'] == 'primary') {
      if ($settings['submit_class'] != 'none') {
        $variables['attributes']['class'][] = $settings['submit_class'];
      }
    }
    elseif (isset($element['#type']) && $element['#type'] == 'submit') {
      $variables['attributes']['class'][] = $settings['button_class'];
    }
  }

}
