<?php

namespace Drupal\monarch_bootstrap\Plugin\Preprocess;

use Drupal\Core\Url;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Pre-processes variables for the page template.
 *
 * @MonarchPreprocess("page")
 */
class Page extends PreprocessBase {

  /**
   * Configuration factory.
   */
  protected $configFactory;

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, array $configuration, $plugin_id, $plugin_definition) {
    $instance = parent::create($container, $configuration, $plugin_id, $plugin_definition);
    $instance->configFactory = $container->get('config.factory');
    return $instance;
  }

  /**
   * {@inheritdoc}
   */
  public function preprocess(array &$variables, $hook, array $info) {
    parent::preprocess($variables, $hook, $info);

    $template = $info['template'];

    // Login pages.
    if (in_array($template, ['page--user--login', 'page--user--register', 'page--user--password', 'page--user--reset'])) {
      $this->preprocessLoginPages($variables, $hook, $info);
    }
  }

  /**
   * Pre-processes variables for the login pages.
   */
  public function preprocessLoginPages(array &$variables, $hook, array $info) {
    $variables['site_name'] = $this->configFactory->get('system.site')->get('name');
    $variables['logo'] = $this->getThemeSetting('logo.url');
    $variables['title'] = $variables['page']['#title'];
    $variables['#cache']['contexts'][] = 'route';
    $variables['page']['#cache']['contexts'][] = 'route';

    // Only show the register account link if visitors have permission to
    // register their accounts.
    $register_url = Url::fromRoute('user.register');
    if ($register_url->access()) {
      $variables['register_url'] = $register_url->toString();
    }
  }
}
