<?php

namespace Drupal\monarch_bootstrap\Plugin\Preprocess;

/**
 * Pre-processes variables for the status messages template.
 *
 * @MonarchPreprocess("status_messages")
 */
class StatusMessages extends PreprocessBase {

  /**
   * {@inheritdoc}
   */
  public function preprocess(array &$variables, $hook, array $info) {
    parent::preprocess($variables, $hook, $info);

    // Translate default message types to bootstrap alerts.
    // See https://getbootstrap.com/docs/5.1/components/alerts/
    $status_map = [
      'status' => 'success',
      'error' => 'danger',
    ];
    foreach ($variables['message_list'] as $type => $messages) {
      if (in_array($type, array_keys($status_map))) {
        $variables['message_list'][$status_map[$type]] = $variables['message_list'][$type];
        unset($variables['message_list'][$type]);
      }
    }
  }

}
