# Monarch Config Zip

A Drush command that exports all site configuration as a ZIP archive.

## Installation

Place this command in your `drush/Commands/contrib/` directory.

## Usage

```bash
drush config:zip > config.zip
```

Or using the alias:

```bash
drush cz > config.zip
```

## Description

The `config:zip` command exports all Drupal configuration from the active configuration storage into a ZIP archive. Each configuration item is saved as an individual YAML file within the archive.

The ZIP file contents are written directly to stdout, allowing you to pipe the output to a file or transfer it via SSH.

## Examples

**Export config locally:**

```bash
drush cz > config.zip
```

**Export config to a local file from a remote using a drush alias:**

```bash
drush @example.alias cz > config.zip
```

**Extract the downloaded config:**

```bash
unzip config.zip -d ./config/sync/
```
