# Monarch Config Zip

Drush commands for exporting and pulling site configuration as ZIP archives.

## Installation

Place this command in your `drush/Commands/contrib/` directory.

## Commands

### config:zip (cz)

Exports all site configuration as a ZIP archive to stdout.

```bash
drush config:zip > config.zip
```

Or using the alias:

```bash
drush cz > config.zip
```

### config:zip-pull (czp)

Pulls configuration from a remote site and extracts it to the local config sync directory.

```bash
drush config:zip-pull @remote.dev
```

Or using the alias:

```bash
drush czp @remote.prod
```

This command will:

1. Check for uncommitted changes in the config sync directory (if git is available)
1. Connect to the remote site and run `config:zip`
1. Download and extract the configuration to the local config sync directory

## Description

The `config:zip` command exports all Drupal configuration from the active configuration storage into a ZIP archive. Each configuration item is saved as an individual YAML file within the archive.

The ZIP file contents are written directly to stdout, allowing you to pipe the output to a file or transfer it via SSH.

The `config:zip-pull` command combines the export and import process into a single command, making it easy to pull configuration from a remote environment.

## Examples

**Export config locally:**

```bash
drush cz > config.zip
```

**Export config to a local file from a remote using a drush alias:**

```bash
drush @example.alias cz > config.zip
```

**Extract the downloaded config:**

```bash
unzip config.zip -d ./config/sync/
```

**Pull config from remote and update local config sync directory:**

```bash
drush czp @remote.dev
```
