<?php

namespace Drupal\monarch_linkit\Plugin\Linkit\Matcher;

use Drupal\Core\Form\FormStateInterface;
use Drupal\linkit\Plugin\Linkit\Matcher\EntityMatcher;

/**
 * Overridden Media matcher to include status check.
 *
 * @see monarch_linkit_linkit_matchers_alter().
 */
class MediaMatcher extends EntityMatcher {

  /**
   * {@inheritdoc}
   */
  public function getSummary() {
    $summary = parent::getSummary();
    $summary[] = $this->t('Include inactive: @include_inactive', [
      '@include_inactive' => $this->configuration['include_inactive'] ? $this->t('Yes') : $this->t('No'),
    ]);
    return $summary;
  }

  /**
   * {@inheritdoc}
   */
  public function defaultConfiguration() {
    return parent::defaultConfiguration() + [
      'include_inactive' => FALSE,
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function calculateDependencies() {
    return parent::calculateDependencies() + [
      'module' => ['monarch_linkit'],
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function buildConfigurationForm(array $form, FormStateInterface $form_state) {
    $form = parent::buildConfigurationForm($form, $form_state);

    $form['include_inactive'] = [
      '#title' => t('Include inactive media'),
      '#type' => 'checkbox',
      '#default_value' => $this->configuration['include_inactive'],
      '#description' => t('In order to see inactive media, the requesting user must also have permissions to do so.'),
    ];

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function submitConfigurationForm(array &$form, FormStateInterface $form_state) {
    parent::submitConfigurationForm($form, $form_state);
    $this->configuration['include_inactive'] = $form_state->getValue('include_inactive');
  }

  /**
   * {@inheritdoc}
   */
  protected function buildEntityQuery($match) {
    $query = parent::buildEntityQuery($match);

    if (empty($this->configuration['include_inactive'])) {
      $query->condition('status', 1);
    }

    return $query;
  }

}
