<?php

namespace Drupal\monarch_media_canonical_download\EventSubscriber;

use Drupal\Core\Routing\RouteSubscriberBase;
use Drupal\Core\Routing\RoutingEvents;
use Drupal\monarch_media_canonical_download\Controller\MediaCanonicalDownloadController;
use Symfony\Component\Routing\RouteCollection;

/**
 * COS Media as File route subscriber.
 */
class RouteSubscriber extends RouteSubscriberBase {

  /**
   * {@inheritdoc}
   */
  protected function alterRoutes(RouteCollection $collection) {
    if (
      ($route = $collection->get('entity.media.canonical')) &&
      \Drupal::config('media.settings')->get('standalone_url')
    ) {
      $defaults = $route->getDefaults();
      unset($defaults['_entity_view']);
      $defaults['_controller'] = '\\' . MediaCanonicalDownloadController::class . '::build';
      $route->setDefaults($defaults);
    }
  }

  /**
   * {@inheritdoc}
   */
  public static function getSubscribedEvents(): array {
    $events = parent::getSubscribedEvents();
    $events[RoutingEvents::ALTER] = ['onAlterRoutes', -300];
    return $events;
  }

}
