<?php

namespace Drupal\monarch_migration_d7\Plugin\MigrationMapper;

use Drupal\migrate\MigrateSkipRowException;
use Drupal\migrate\Row;

/**
 * Maps fields.
 *
 * @MigrationMapper(
 *   id = "monarch_migration_d7_menu",
 *   migration = "menu",
 *   weight = -9999,
 * )
 */
class Menu extends MigrationMapperD7Base {

  /**
   * {@inheritdoc}
   */
  public function prepareRow(Row $row) {
    if (preg_match('/^(devel|shortcut-set-)/', $row->getSourceProperty('menu_name'))) {
      throw new MigrateSkipRowException();
    }

    $row->setDestinationProperty('id', $this->machineName('mig-' . $row->getSourceProperty('menu_name'), '-'));
    $row->setDestinationProperty('label', $row->getSourceProperty('title') . ' (migrated)');
    $row->setDestinationProperty('description', 'Migrated from Drupal 7. ' . $row->getSourceProperty('description'));
    $row->setDestinationProperty('langcode', $row->getSourceProperty('language') ?: 'und');
  }

}
