<?php

namespace Drupal\monarch_migration_d7\Plugin\MigrationMapper;

use Drupal\migrate\Row;

/**
 * Maps fields.
 *
 * @MigrationMapper(
 *   id = "monarch_migration_d7_taxonomy_term",
 *   migration = "taxonomy_term",
 *   weight = -9999,
 * )
 */
class TaxonomyTerm extends MigrationMapperD7Base {

  /**
   * {@inheritdoc}
   */
  public function prepareRow(Row $row) {
    $row->setDestinationProperty('tid', $tid = $row->getSourceProperty('tid'));
    $row->setDestinationProperty('revision_id', $row->getSourceProperty('tid'));
    $row->setDestinationProperty('vid', $row->getSourceProperty('machine_name'));
    $row->setDestinationProperty('name', $row->getSourceProperty('name'));
    $row->setDestinationProperty('weight', $row->getSourceProperty('weight'));
    if ($row->hasSourceProperty('status')) {
      $row->setDestinationProperty('status', $status = $row->getSourceProperty('status'));
      $row->setDestinationProperty('moderation_state', $status == 1 ? 'published' : 'draft');
    }
    $row->setDestinationProperty('changed', $row->getSourceProperty('timestamp'));
    $row->setDestinationProperty('description', [
      'value' => $row->getSourceProperty('description'),
      'format' => $row->getSourceProperty('format'),
    ]);

    $lookup_path = "taxonomy/term/$tid";
    $aliases = $this->getAliases($lookup_path);

    if ($alias = array_pop($aliases)) {
      $row->setDestinationProperty('path', [
        'alias' => '/' . ltrim($alias, '/'),
        'pathauto' => FALSE,
      ]);
    }

    foreach (($this->fieldInfo['taxonomy_term'] = $this->fieldInfo['taxonomy_term'] ?? static::getBundleFields('taxonomy_term')) as $field_name => $field_type) {
      if ($row->hasSourceProperty($field_name)) {
        $row->setSourceProperty($field_name, $this->processField($field_type, $row->getSourceProperty($field_name)));
      }
    }
  }

  /**
   * {@inheritdoc}
   */
  public function processRow(Row $row) {
    $parent_id = $row->getSourceProperty('parent');

    while (is_array($parent_id)) {
      $parent_id = reset($parent_id);
    }

    if (!empty($parent_id)) {
      $looked_up_parent_id = $this->executePlugin('migration_lookup', $parent_id, $row, [
        'migration' => ['taxonomy_term'],
      ]);

      $row->setDestinationProperty('parent_id', $looked_up_parent_id);
    }
  }

  /**
   * {@inheritdoc}
   */
  public function postRowSave(Row $row) {
    $tid = $row->getSourceProperty('tid');
    $lookup_path = "taxonomy/term/$tid";
    $aliases = $this->getAliases($lookup_path);
    $redirects = $this->getRedirects($lookup_path);
    array_pop($aliases);

    if (count($aliases) > 0) {
      foreach ($aliases as $pid => $alias) {
        $this->createRedirect("new_alias_redirect:$pid", [
          'uid' => 0,
          'language' => 'und',
          'status_code' => '301',
          'redirect_source' => [
            'path' => ltrim($alias, '/'),
            'query' => NULL,
          ],
          'redirect_redirect' => [
            'uri' => "internal:/$lookup_path",
          ],
        ]);
      }
    }

    if (count($redirects) > 0) {
      foreach ($redirects as $rid => $redirect) {
        $this->createRedirect("new_redirect:$rid", [
          'uid' => $redirect['uid'],
          'language' => $redirect['language'],
          'status_code' => $redirect['status_code'] ?: '307',
          'redirect_source' => [
            'path' => $redirect['source'],
            'query' => $redirect['source_options']['query'] ?? NULL,
          ],
          'redirect_redirect' => [
            'uri' => "internal:/$lookup_path",
          ],
        ]);
      }
    }
  }

}
