<?php

namespace Drupal\monarch_migration_d7\Form;

use Drupal\Core\Database\Database;
use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Configure Monarch Migration D7 role map settings for this site.
 */
class RoleMap extends ConfigFormBase {

  /**
   * The entity type manager service.
   *
   * @var \Drupal\Core\Entity\EntityTypeManagerInterface
   */
  protected $entityTypeManager;

  /**
   * The source database.
   *
   * @var \Drupal\Core\Database\Connection
   */
  protected $sourceDatabase;

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container) {
    $instance = parent::create($container);

    $instance->entityTypeManager = $container->get('entity_type.manager');
    $instance->sourceDatabase = Database::getConnection('default', 'legacy');

    return $instance;
  }

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'monarch_migration_d7_role_map';
  }

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return ['monarch_migration_d7.settings'];
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $settings = $this->config('monarch_migration_d7.settings')->get('role_settings');

    $form['#tree'] = TRUE;

    $d7_roles = $this->sourceDatabase->select('role', 'r')->fields('r', ['rid', 'name'])->execute()->fetchAllKeyed(0, 1);

    $d9_roles = [
      'authenticated',
    ];

    foreach ($this->entityTypeManager->getStorage('user_role')->loadMultiple() ?: [] as $key => $role) {
      $d9_roles[$key] = $role->label();
    }

    $form['role_settings'] = [];

    foreach ($d7_roles as $rid => $name) {
      $form['role_settings'][$rid] = [
        '#type' => 'select',
        '#title' => $this->t('Role <em>@source_role</em> maps to:', [
          '@source_role' => $name,
        ]),
        '#options' => $d9_roles,
        '#default_value' => $this->config('monarch_migration_d7.settings')->get("role_settings.$rid"),
        '#empty_option' => $this->t('- Do Not Use -'),
        '#weight' => intval($rid),
      ];
    }

    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $this->config('monarch_migration_d7.settings')
      ->set('role_settings', $form_state->getValue('role_settings'))
      ->save();

    parent::submitForm($form, $form_state);
  }

}
