<?php

namespace Drupal\monarch_migration_d7\Plugin\MigrationMapper;

use Drupal\migrate\Row;

/**
 * Maps fields.
 *
 * @MigrationMapper(
 *   id = "monarch_migration_d7_custom_block",
 *   migration = "custom_block",
 *   weight = -9999,
 * )
 */
class CustomBlock extends MigrationMapperD7Base {

  /**
   * {@inheritdoc}
   */
  public function requirements() : ?array {
    return ['file'];
  }

  /**
   * {@inheritdoc}
   */
  public function prepareRow(Row $row) {
    $row->setDestinationProperty('type', 'basic');
    $row->setDestinationProperty('info', $row->getSourceProperty('info'));

    $body = $this->processField('text_long', [
      [
        'value' => $row->getSourceProperty('body') ?: '',
        'summary' => NULL,
        'format' => 'full_html',
      ],
    ]);

    $row->setDestinationProperty('body', $body);
  }

}
