<?php

namespace Drupal\monarch_migration_d7\Plugin\MigrationMapper;

use Drupal\migrate\Row;

/**
 * Maps fields.
 *
 * @MigrationMapper(
 *   id = "monarch_migration_d7_node",
 *   migration = "node",
 *   weight = -9999,
 * )
 */
class Node extends MigrationMapperD7Base {

  /**
   * {@inheritdoc}
   */
  public function requirements() : ?array {
    return ['user'];
  }

  /**
   * {@inheritdoc}
   */
  public function prepareRow(Row $row) {
    $row->setDestinationProperty('type', $row->getSourceProperty('type'));
    $row->setDestinationProperty('nid', $nid = $row->getSourceProperty('tnid'));
    $row->setDestinationProperty('vid', $row->getSourceProperty('vid'));
    $row->setDestinationProperty('title', $row->getSourceProperty('title'));
    $row->setDestinationProperty('uid', $row->getSourceProperty('node_uid'));
    if ($row->hasSourceProperty('status')) {
      $row->setDestinationProperty('status', $status = $row->getSourceProperty('status'));
      $row->setDestinationProperty('moderation_state', $status == 1 ? 'published' : 'draft');
    }
    $row->setDestinationProperty('created', $row->getSourceProperty('created'));
    $row->setDestinationProperty('changed', $row->getSourceProperty('timestamp'));
    $row->setDestinationProperty('promote', $row->getSourceProperty('promote'));
    $row->setDestinationProperty('sticky', $row->getSourceProperty('sticky'));
    $row->setDestinationProperty('revision_uid', $row->getSourceProperty('revision_uid'));
    $row->setDestinationProperty('revision_log', $row->getSourceProperty('log'));
    $row->setDestinationProperty('revision_timestamp', $row->getSourceProperty('timestamp'));
    $row->setDestinationProperty('content_translation_source', $row->getSourceProperty('source_langcode'));

    $lookup_path = "node/$nid";
    $aliases = $this->getAliases($lookup_path);

    if ($alias = array_pop($aliases)) {
      $row->setDestinationProperty('path', [
        'alias' => '/' . ltrim($alias, '/'),
        'pathauto' => FALSE,
      ]);
    }

    $row->isPrepared = $row->isPrepared ?? NULL;

    if (!$row->isPrepared) {
      foreach (($this->fieldInfo['node'] = $this->fieldInfo['node'] ?? static::getBundleFields('node')) as $field_name => $field_type) {
        if ($row->hasSourceProperty($field_name)) {
          $row->setSourceProperty($field_name, $this->processField($field_type, $row->getSourceProperty($field_name)));
        }
      }

      $row->isPrepared = TRUE;
    }
  }

  /**
   * {@inheritdoc}
   */
  public function postRowSave(Row $row) {
    $nid = $row->getSourceProperty('tnid');
    $lookup_path = "node/$nid";
    $aliases = $this->getAliases($lookup_path);
    $redirects = $this->getRedirects($lookup_path);
    array_pop($aliases);

    if (count($aliases) > 0) {
      foreach ($aliases as $pid => $alias) {
        $this->createRedirect("new_alias_redirect:$pid", [
          'uid' => 0,
          'language' => 'und',
          'status_code' => '301',
          'redirect_source' => [
            'path' => ltrim($alias, '/'),
            'query' => NULL,
          ],
          'redirect_redirect' => [
            'uri' => "internal:/$lookup_path",
          ],
        ]);
      }
    }

    if (count($redirects) > 0) {
      foreach ($redirects as $rid => $redirect) {
        $this->createRedirect("new_redirect:$rid", [
          'uid' => $redirect['uid'],
          'language' => $redirect['language'],
          'status_code' => $redirect['status_code'] ?: '307',
          'redirect_source' => [
            'path' => $redirect['source'],
            'query' => $redirect['source_options']['query'] ?? NULL,
          ],
          'redirect_redirect' => [
            'uri' => "internal:/$lookup_path",
          ],
        ]);
      }
    }
  }

}
