<?php

namespace Drupal\monarch_migration\Annotation;

use Drupal\Component\Annotation\Plugin;

/**
 * Defines a migration mapper plugin.
 *
 * Plugin Namespace: Plugin\MigrationMapper.
 *
 * @see plugin_api
 *
 * @Annotation
 */
class MigrationMapper extends Plugin {

  /**
   * The migration(s) that this applies to.
   *
   * @var string|string[]|null
   */
  protected $migration = NULL;

  /**
   * The source modules that are required for this plugin.
   *
   * @var string|string[]|null
   */
  protected $source_module = NULL;

  /**
   * The plugin weight.
   *
   * @var int
   */
  protected $weight = 0;

}
