<?php

namespace Drupal\monarch_migration;

use Drupal\Core\Entity\EntityInterface;
use Drupal\migrate\Row;

/**
 * Defines the interface for a migration mapper plugin.
 */
interface MigrationMapperInterface {

  /**
   * Define migration requirements for this plugin.
   */
  public function requirements() : ?array;

  /**
   * The allow defining migrations programmatically.
   *
   * Definitions from higher weighted plugins take presidence.
   */
  public function definitions() : ?array;

  /**
   * The allow altering the migration definition.
   *
   * @param array $definition
   *   The migration definition.
   */
  public function definitionAlter(array &$definition);

  /**
   * The prepareRow event.
   *
   * @param \Drupal\migrate\Row $row
   *   The migration row.
   */
  public function prepareRow(Row $row);

  /**
   * The processRow event.
   *
   * @param \Drupal\migrate\Row $row
   *   The migration row.
   */
  public function processRow(Row $row);

  /**
   * The cleanup event for monarch migration destination plugins.
   *
   * @param \Drupal\migrate\Row $row
   *   The migration row.
   * @param \Drupal\Core\Entity\EntityInterface $entity
   *   The entity being saved.
   */
  public function cleanup(Row $row, EntityInterface $entity);

  /**
   * The postRowSave event.
   *
   * @param \Drupal\migrate\Row $row
   *   The migration row.
   */
  public function postRowSave(Row $row);

  /**
   * The get the migration ids.
   */
  public function getMigrations() : array;

  /**
   * The get the source module names.
   */
  public function getSourceModules() : array;

  /**
   * Does this plugin apply to the specified migration?
   */
  public function isApplicable(string $migration_id);

  /**
   * Get the plugin weight.
   */
  public function getWeight();

  /**
   * Checks if a module is enabled in the source.
   */
  public function sourceModuleEnabled(string $module_name);

  /**
   * Modify to make a machine name.
   */
  public function machineName(string $potential_name) : string;

}
