<?php

namespace Drupal\monarch_migration;

use Drupal\Core\Cache\CacheBackendInterface;
use Drupal\Core\Plugin\DefaultPluginManager;
use Drupal\Core\Extension\ModuleHandlerInterface;

/**
 * The migration mapper plugin manager.
 */
class MigrationMapperPluginManager extends DefaultPluginManager {

  /**
   * Constructs a MigrationMapperPluginManager object.
   *
   * @param \Traversable $namespaces
   *   An object that implements \Traversable which contains the root paths
   *   keyed by the corresponding namespace to look for plugin implementations.
   * @param \Drupal\Core\Cache\CacheBackendInterface $cache_backend
   *   Cache backend instance to use.
   * @param \Drupal\Core\Extension\ModuleHandlerInterface $module_handler
   *   The module handler to invoke the alter hook with.
   */
  public function __construct(\Traversable $namespaces, CacheBackendInterface $cache_backend, ModuleHandlerInterface $module_handler) {
    parent::__construct(
      'Plugin/MigrationMapper',
      $namespaces,
      $module_handler,
      'Drupal\monarch_migration\MigrationMapperInterface',
      'Drupal\monarch_migration\Annotation\MigrationMapper'
    );

    $this->setCacheBackend($cache_backend, 'migration_mapper_info_plugins');
  }

  /**
   * Get plugins for a migration.
   */
  public function getPlugins(string $migration = NULL, array $configuration = []) : array {
    $plugins = [];

    foreach (($definitions = $this->getDefinitions()) as $definition) {
      $plugin = $this->createInstance($definition['id'], $configuration);

      if (is_null($migration) || $plugin->isApplicable($migration)) {
        $plugins[] = $plugin;
      }
    }

    usort($plugins, function ($a, $b) {
      return $a->getWeight() - $b->getWeight();
    });

    return $plugins;
  }

}
