<?php

namespace Drupal\monarch_migration\Plugin\MigrationMapper;

use Drupal\migrate\Row;

/**
 * Maps fields.
 *
 * @MigrationMapper(
 *   id = "monarch_migration_create_entity",
 *   migration = {
 *     "create_block",
 *     "create_paragraph",
 *     "create_redirect",
 *   },
 *   weight = -9999,
 * )
 */
class CreateEntity extends MigrationMapperBase {

  /**
   * {@inheritdoc}
   */
  public function processRow(Row $row) {
    $source = $row->getSource();

    foreach ($source as $source_key => $source_value) {
      $row->setDestinationProperty($source_key, $source_value);
    }
  }

}
