<?php

namespace Drupal\monarch_migration\Plugin\migrate\process;

use Drupal\migrate\Row;
use Drupal\migrate\ProcessPluginBase;
use Drupal\migrate\MigrateExecutableInterface;
use Drupal\Core\Plugin\ContainerFactoryPluginInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Provides a monarch_migration_process_helper plugin.
 *
 * @MigrateProcessPlugin(
 *   id = "monarch_migration_process_helper"
 * )
 */
class MonarchMigrationProcessHelper extends ProcessPluginBase implements ContainerFactoryPluginInterface {

  /**
   * The migration mapper plugin manager.
   *
   * @var \Drupal\monarch_migration\MigrationMapperPluginManager
   */
  protected $pluginManager;

  /**
   * The migration.
   *
   * @var \Drupal\migrate\Plugin\MigrationInterface
   */
  protected $migration;

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, array $configuration, $plugin_id, $plugin_definition, $migration = NULL) {
    $instance = new static(
      $configuration,
      $plugin_id,
      $plugin_definition,
    );

    $instance->pluginManager = $container->get('plugin.manager.monarch_migration.hook');
    $instance->migration = $migration;

    return $instance;
  }

  /**
   * {@inheritdoc}
   */
  public function transform($value, MigrateExecutableInterface $migrate_executable, Row $row, $destination_property) {
    foreach ($this->pluginManager->getPlugins($this->migration->getPluginId(), [
      'migration' => $this->migration,
      'migrate_executable' => $migrate_executable,
      'destination_property' => $destination_property,
    ]) as $plugin) {
      /** @var \Drupal\monarch_migration\MigrationMapperInterface $plugin */
      $plugin->processRow($row);
    }

    return NULL;
  }

}
