<?php

namespace Drupal\monarch_rest_plugin;

use Drupal\Component\Plugin\PluginBase;

/**
 * Base class for rest_api plugins.
 */
abstract class RestApiPluginBase extends PluginBase {

  /**
   * Get a list of routes provided by this plugin.
   */
  public function getRoutes() : iterable {
    $ret = [];

    $route = ($this->pluginDefinition['route'] ?? explode('\\', get_class($this), 5)[4] ?? $this->pluginDefinition['id']);

    if (is_string($route)) {
      $function = ($this->pluginDefinition['entry_point'] ?? '__invoke');
      $access = ($this->pluginDefinition['access'] ?? 'access');

      if (is_string($function) && method_exists($this, $function)) {
        if (is_string($access) && method_exists($this, $access)) {
          $ret[] = new RestApiRoute($route, [$this, $function], [$this, $access]);
        }
        else {
          $ret[] = new RestApiRoute($route, [$this, $function]);
        }
      }
    }

    return $ret;
  }

}
