<?php

namespace Drupal\monarch_rest_plugin\EventSubscriber;

use Drupal\Core\Routing\RouteSubscriberBase;
use Drupal\monarch_rest_plugin\Controller\MonarchRestPluginController;
use Drupal\monarch_rest_plugin\RestApiPluginManager;
use Symfony\Component\Routing\Route;
use Symfony\Component\Routing\RouteCollection;

/**
 * Route subscriber.
 */
final class MonarchRestPluginRouteSubscriber extends RouteSubscriberBase {

  /**
   * Constructs a MonarchRestPluginRouteSubscriber object.
   */
  public function __construct(
    private readonly RestApiPluginManager $pluginManagerRestApi,
  ) {}

  /**
   * {@inheritdoc}
   */
  protected function alterRoutes(RouteCollection $collection): void {
    foreach ($this->pluginManagerRestApi->getRoutes() as $path => $route) {
      $machine_name = 'monarch_rest_plugin.' . str_replace('/', '_slash_', $path);
      $class = MonarchRestPluginController::class;
      /** @var \Drupal\monarch_rest_plugin\RestApiRoute */
      $collection->add($machine_name, new Route($path, [
        '_title' => 'Monarch Rest Plugin - ' . $path,
        '_controller' => "\\$class::build",
      ], [
        '_custom_access' => "\\$class::access",
      ]));
    }
  }

}
