<?php

namespace Drupal\monarch_rest_plugin;

/**
 * Interface for rest_api plugins.
 */
class RestApiRoute {

  /**
   * The route for an API.
   */
  protected string $route;

  /**
   * The callback for the API.
   */
  protected mixed $callback;

  /**
   * The callback for access to the API.
   */
  protected mixed $access;

  /**
   * Construct the object.
   *
   * @param string $route
   *   The route for the API.
   * @param callable $callback
   *   The callback for the API.
   * @param callable $access
   *   The callback for access to the API.
   */
  public function __construct(string $route, callable $callback, ?callable $access = NULL) {
    if ($route[0] !== '/') {
      $route = '/' . $route;
    }

    $route = str_replace('\\', '/', $route);

    $this->route = $route;
    $this->callback = $callback;
    $this->access = $access;
  }

  /**
   * Get the route path for the route.
   *
   * @return string
   *   The route string.
   */
  public function getRoute() : string {
    return $this->route;
  }

  /**
   * Get the closure.
   *
   * @return callable
   *   The callback for the route.
   */
  public function getCallback() : callable {
    return $this->callback;
  }

  /**
   * Get the closure.
   *
   * @return ?callable
   *   The callback for the route.
   */
  public function getAccessCallback() : ?callable {
    return $this->access;
  }

}
