<?php

namespace Drupal\monarch_vbo\Controller;

use Drupal\Core\Access\AccessResult;
use Drupal\Core\Controller\ControllerBase;
use Drupal\Core\Session\AccountInterface;
use Drupal\monarch_vbo\Plugin\Action\MediaDownloadAction;
use Symfony\Component\HttpFoundation\BinaryFileResponse;
use Symfony\Component\HttpKernel\Exception\NotFoundHttpException;

/**
 * Controller for the media VBO download.
 */
class MediaVboDownloadController extends ControllerBase {

  /**
   *
   */
  public function content($id) {
    $filename = MediaDownloadAction::getFileName($id);

    if (!file_exists($filename)) {
      throw new NotFoundHttpException();
    }

    return [
      '#theme' => 'media_vbo_download_archive',
      '#id' => $id,
    ];
  }

  /**
   * Download the file.
   */
  public function download($id) {
    $filename = MediaDownloadAction::getFileName($id);

    if (!file_exists($filename)) {
        throw new NotFoundHttpException();
    }

    $download_filename = $id . '.zip';

    return new BinaryFileResponse($filename, 200, [
      'Content-Type' => 'application/zip',
      'Content-Disposition' => 'attachment; filename="media-archive-' . $download_filename . '"',
    ]);
  }

  /**
   * The access check for the download route.
   */
  public function access(AccountInterface $account) {
    if ($account->hasPermission('download bulk media archive')) {
      return AccessResult::allowed();
    }

    return AccessResult::forbidden();
  }

}
