<?php

namespace Drupal\monarch_virtual_field;

use Drupal\Component\Plugin\PluginBase;
use Drupal\Component\Utility\Html;
use Drupal\Core\Entity\ContentEntityInterface;
use Drupal\Core\Form\FormStateInterface;

/**
 * Base class for virtual_field_widget plugins.
 */
abstract class VirtualFieldWidgetPluginBase extends PluginBase implements VirtualFieldWidgetInterface {

  /**
   * {@inheritdoc}
   */
  public function label() {
    // Cast the label to a string since it is a TranslatableMarkup object.
    return (string) $this->pluginDefinition['label'];
  }

  /**
   * {@inheritdoc}
   */
  public function appliesTo(string $entity_type_id, string $bundle) {
    return TRUE;
  }

  /**
   * {@inheritdoc}
   */
  public function build(ContentEntityInterface $entity, array &$form, FormStateInterface $form_state, $form_id) : ?array {
    return NULL;
  }

  /**
   * {@inheritdoc}
   */
  public function buildField(ContentEntityInterface $entity, array &$form, FormStateInterface $form_state, $form_id) {
    if (!is_null($element = static::build($entity, $form, $form_state, $form_id))) {
      $form["#validate"][] = [$this, 'validateField'];
      $parents = $form['#parents'];
      $field_name = $this->pluginDefinition['id'];

      $form[$field_name] = [
        '#type' => 'container',
        '#parents' => [...$parents, $field_name],
        '#attributes' => [
          'class' => [
            'field--type-' . Html::getClass('virtual_field'),
            'field--name-' . Html::getClass($field_name),
            'field--widget-virtual-field-' . Html::getClass($field_name),
          ],
        ],
        'widget' => $element,
      ];
    }
  }

  /**
   * Validate handler.
   */
  public function validateField(array $form, FormStateInterface $form_state) : void {
    $entity = $form_state->getFormObject()->getEntity();
    $field_name = $this->pluginDefinition['id'];
    $values = $form_state->getValue([
      ...$form[$field_name]['#parents'],
      'widget',
    ]);
    $this->validate($values, $entity, $form[$field_name]['widget'], $form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function validate($values, ContentEntityInterface $entity, array $element, array $form, FormStateInterface $form_state) : void {}

}
